/************************************************************************
 * \file: trace_journal_be.c
 *
 * \version: $Id: trace_journal_be.c,v 1.0 2013/05/09 10:27:32
 *
 * creates an executable that can be used to  Trace-out Journal data
 *
 * \component: Gen3 Trace
 *
 * \author : Anitha.BA
 *
 * \copyright: (c) 2013 ADIT
 *
 ************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <syslog.h>
#include <fcntl.h>
#include <unistd.h>
#include <trace_interface.h>
#include <systemd/sd-journal.h>

#define TR_CLASS_JOURNAL                            (0x0C28)
#define L_FAIL_OPEN                                 (23)
#define L_ERR                                       (12)
#define CURRENT_MODE                                (0)
#define BACKUP_MODE                                 (1)
#define L_FAIL_NEXT                                 (32)
#define L_FAIL_WAIT                                 (27)
#define L_FAIL_SEEK_TAIL                            (28)
#define L_FAIL_SEEK_HEAD                            (32)
#define L_FAIL_PREVIOUS                             (28)
#define TEN_KB                                      (10240)
#define JOURNAL_LEVEL                               (0)

#ifndef E_OK
#define E_OK 0
#endif
#ifndef E_FAIL
#define E_FAIL -1
#endif

/*SWGIII-7344*/
#define TRACE_JOURNAL_BUFFER_SIZE 256

static char curBootId[TRACE_JOURNAL_BUFFER_SIZE];
static char prevBootId[TRACE_JOURNAL_BUFFER_SIZE];

/*
 * Copy a string and remove characters, which cannot be displayed.
 * If max_size is reached a null character is added as last character.
 *
 */

int trace_journal_get(sd_journal* j,char *target,const char *field,size_t max_size)
{
	char *data;
	size_t length;
	int error_code;
	size_t field_size;

	// pre check parameters
	if(max_size<1 || target == 0 || field == 0 || j == 0)
		return -1;

	// intialise empty target
	target[0]=0;

	// get data from journal
	error_code = sd_journal_get_data(j, field,(const void **) &data, &length);

	// check if an error
	if(error_code)
		return error_code;

	// calculate field size
	field_size = strlen(field)+1;

	//check length
	if(length<field_size)
		return -1;

	// copy string
	if(max_size<=(length-field_size))
	{
		// truncate
		strncpy(target,data+field_size,max_size-1);
		target[max_size-1]=0;
	}
	else
	{
		// full copy
		strncpy(target,data+field_size,length-field_size);
		target[length-field_size]=0;

	}

	return 0;
}


/**
 * Function called from get_journal_data( )
 *
 * \parm  takes buffer-length, buffer, and traceLevel  as parameters.
 *
 * return \li 0  Normal termination
 */
void Trace_out_journal_logs(S32 length,char Buffer[TEN_KB],TR_tenTraceLevel traceLevel)
{
	TRACE_clas_ena_stat state= TR_ENABLED_CLASS_NONE;
	state = (TRACE_clas_ena_stat)TR_core_bIsClassSelected(TR_CLASS_JOURNAL, traceLevel);
	if ((TR_ENABLED_CLASS_TRC == ((U32)state & TR_ENABLED_CLASS_TRC )) ||( (U32)state & TR_ENABLED_CLASS_PXY)) {
		TR_core_uwTraceOut(length, TR_CLASS_JOURNAL,traceLevel,(void*)Buffer);
	}
}


/**
 * Function called from get_journal_data( )
 *
 * \parm  takes journal-handler and r2 as parameters.
 *
 * return \li 0  Normal termination
 */
void get_cur_bootId(sd_journal *jnlHdlr,S32 r2)
{
	if(jnlHdlr == NULL)
		return ;
	int r_getbootid = 0 ;

	// going to the journal's tail
	r2 = sd_journal_seek_tail(jnlHdlr);
	if(r2 < E_OK) {
		TR_core_uwTraceOut(L_FAIL_SEEK_TAIL, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"sd_journal_seek_tail_failed");
	}

	// going to the latest entry
	r2 = sd_journal_previous(jnlHdlr);
	if(r2 < E_OK) {
		TR_core_uwTraceOut(L_FAIL_PREVIOUS, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"sd_journal_seek_previous_failed");
	}

	// getting boot_id of that entry and storing it as current boot_id

	r_getbootid =  trace_journal_get(jnlHdlr,curBootId,"_BOOT_ID",sizeof(curBootId));

	if(r_getbootid < 0) /*SWGIII-7329*/
	{
		TR_core_uwTraceOut(L_ERR, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"BID_cur_fail");

	}

}



/**
 * Function called from main( )
 *
 * \parm  takes journal handler,r2, and currentbootid as parameters.
 *
 * return \li 0  Normal termination
 */
void  get_prev_bootId(sd_journal *jnlHdlr,S32 r2)
{
	int r_getbootid = 0 ;
	if(jnlHdlr == NULL)
		return ;

	char bootId[TRACE_JOURNAL_BUFFER_SIZE] = "";
	BOOL isExit = FALSE;
	//do_while_loop used for iterating through the journal backwards untill the boot_id changes
	do {
		r2 = sd_journal_previous(jnlHdlr);
		if(r2 < E_OK){
			TR_core_uwTraceOut(L_FAIL_PREVIOUS, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"sd_journal_seek_previous_failed");
		}
		r_getbootid = trace_journal_get(jnlHdlr,bootId,"_BOOT_ID",sizeof(bootId));
		if(r_getbootid < 0 )
		{
			//				TR_core_uwTraceOut(L_ERR, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"pbid_get_fail");

		}
		if ((strcmp(curBootId,bootId )) != 0)

		{
			TR_core_uwTraceOut(L_ERR, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"BId_prev_2");
			r_getbootid=trace_journal_get(jnlHdlr,prevBootId,"_BOOT_ID",sizeof(prevBootId));
			if(r_getbootid < 0 )
			{
				//					TR_core_uwTraceOut(L_ERR, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"pbid_get_fail");

			}
			// when the boot-id is changed, it's value is saved as previous bootId
			isExit = TRUE;  // to come out of the do_while
		}
	}while((isExit == FALSE) && (r2 != E_OK));// r2= 0 indicates EOF

	//        going back to the head to trace_out from the oldest entry
	r2 = sd_journal_seek_head(jnlHdlr);
	if(r2 < E_OK)
	{
		TR_core_uwTraceOut(L_FAIL_SEEK_HEAD, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"sd_journal_seek_head_failed");
	}
}


/**
 * Function called from main( )
 *
 * \parm  takes one mode as parameter.
 *
 * return \li 0  Normal termination
 */
int get_journal_data(int mode)
{
	S32 r               = E_OK;
	S32 r1              = E_OK;
	S32 r2              = E_OK;
	S32 length          = 0;
	S32 notify          = 0;
	S32 dotrace         = 0;
	sd_journal *jnlHdlr = NULL;

	/*SWGIII-7329*/
	int r_getbootid     = 0 ;
	int r_getprio       = 0 ;
	int r_getmsg        = 0 ;
	int r_getexe        = 0 ;
	int r_gettimestamp  = 0 ;

	/*SWGIII-7344*/
	char buffer_timStmp[TRACE_JOURNAL_BUFFER_SIZE]= "";
	char buffer_exe[TRACE_JOURNAL_BUFFER_SIZE]    = "";
	char buffer_msg[TRACE_JOURNAL_BUFFER_SIZE]    = "";
	char buffer_prio[TRACE_JOURNAL_BUFFER_SIZE]   = ""; 
	char buffer_bootId[TRACE_JOURNAL_BUFFER_SIZE] = "";


	//	TRACE_clas_ena_stat state= TR_ENABLED_CLASS_NONE;
	TR_tenTraceLevel traceLevel= TR_LEVEL_USER_4;
	/*opening the journal*/
	r = sd_journal_open(&jnlHdlr, SD_JOURNAL_LOCAL_ONLY);/*variable r is used in infinite while loop below*/
	if (r < E_OK) {
		TR_core_uwTraceOut(L_FAIL_OPEN, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"Failed to open journal");
		return 1;
	}

	/*******getting current-bootid and previous-bootid**************************/


	/******got the current & previous  bootids .Now tracing out only the required(current/prev) logs and dropping the other logs ****************/
	/*while-loop to trace_out the logs whenever the journal data is changed*/
	while  ((r>=E_OK)&&(r1>=E_OK))  {

		/*iterating to next entry*/
		r = sd_journal_next(jnlHdlr);
		if(r>E_OK) {

			/*getting the required fields*/

			/*SWGIII-7344*/

			memset(buffer_msg,0,TRACE_JOURNAL_BUFFER_SIZE);
			memset(buffer_bootId,0,TRACE_JOURNAL_BUFFER_SIZE);
			memset(buffer_prio,0,TRACE_JOURNAL_BUFFER_SIZE);
			memset(buffer_exe,0,TRACE_JOURNAL_BUFFER_SIZE);
			memset(buffer_timStmp,0,TRACE_JOURNAL_BUFFER_SIZE);

			r_getmsg = trace_journal_get(jnlHdlr,buffer_msg,"MESSAGE",sizeof(buffer_msg));
			if(r_getmsg < 0 )
			{
				//				TR_core_uwTraceOut(L_ERR, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"msg_get_fail");

			}

			r_getbootid = trace_journal_get(jnlHdlr,buffer_bootId,"_BOOT_ID",sizeof(buffer_bootId));

			if(r_getbootid < 0)
			{
				//				TR_core_uwTraceOut(L_ERR, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"BID_get_fail");

			}



			r_getprio = trace_journal_get(jnlHdlr,buffer_prio,"PRIORITY",sizeof(buffer_prio));

			if(r_getprio < 0)
			{
				//				TR_core_uwTraceOut(L_ERR, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"prio_get_fail");

			}


			r_getexe = trace_journal_get(jnlHdlr,buffer_exe,"_EXE",sizeof(buffer_exe));

			if(r_getexe < 0 )
			{

				//				TR_core_uwTraceOut(L_ERR, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"exe_get_fail");

			}



			r_gettimestamp =  trace_journal_get(jnlHdlr,buffer_timStmp,"_SOURCE_REALTIME_TIMESTAMP",sizeof(buffer_timStmp));

			if(r_gettimestamp < 0)
			{
				//				TR_core_uwTraceOut(L_ERR, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"tim_get_fail");

			}

                         get_cur_bootId(jnlHdlr,r2);
                         if(mode == BACKUP_MODE)
                         get_prev_bootId(jnlHdlr,r2);


			static char Buffer[TEN_KB];

			switch (mode) {

				case CURRENT_MODE:

					/*The bootids are checked for current bootids*/
					if (strcmp(curBootId,buffer_bootId)==0) {
						length = snprintf(Buffer, TEN_KB,"%s%s\t\t%s%s\t\t%s%s\t\t%s%s\t","		EXE=",buffer_exe,"MSG=",buffer_msg,"PRIO=",buffer_prio,"BOOT_ID=",buffer_bootId);/*fillup the buffer to be traced_out*/

						dotrace = 1;
					}


					else {
						/*do nothing*/
					}

					break;

				case BACKUP_MODE:

					/* boot-ids are checked for current and previous boot-ids*/
					if (strcmp(prevBootId,buffer_bootId)==0) {
						length = snprintf(Buffer, TEN_KB,"%s%s\t%s%s\t%s%s\t%s%s\t","EXE=",buffer_exe,"MSG=",buffer_msg,"PRIO=",buffer_prio,"BOOT_ID=",buffer_bootId);/*fillup the buffer to be traced_out*/

						dotrace = 1;
					}

					if (strcmp(curBootId,buffer_bootId)==0) {
						if(notify != -1) {
							length = snprintf(Buffer, TEN_KB, "\n\n%s\n\n\t%s\t%s\t%s\t%s\t" ,"......REBOOT happened....going to trace logs of previous lifecycle.......", buffer_exe,buffer_msg,buffer_prio,buffer_bootId);
							notify = -1;
							dotrace = 1;
						}
						else {
							length = snprintf(Buffer, TEN_KB,"%s\t%s\t%s\t%s\t",buffer_exe,buffer_msg,buffer_prio,buffer_bootId);/*fillup the buffer to be traced_out*/
							dotrace = 1;
						}
					}



					else {
						/*do nothing*/
					}

					break;

				default:


					break;

			}

			/*Trace_out*/
			if (dotrace == 1)  {

				Trace_out_journal_logs(length,Buffer,traceLevel);

			}

		}

		else if (r == E_OK)  {

			// Reached the end, let's wait for changes, and try again
			r1 = sd_journal_wait(jnlHdlr, 1000000);
			if (r1 < E_OK) {
				TR_core_uwTraceOut(L_FAIL_WAIT, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP) "Failed to wait for changes");
				r1 = E_FAIL;/*breaking the while...else continue*/
                                break;
			}
                       continue;
		}

		else  if (r < E_OK) {
			TR_core_uwTraceOut(L_FAIL_NEXT, TR_CLASS_JOURNAL,TR_LEVEL_ERRORS,(VP)"Failed to iterate to next entry");

		}

		else {
			/*do nothing*/
		}

	}/*end of while loop*/

	/*closing the journal*/
	sd_journal_close(jnlHdlr);
	return 0;
}


/**
 * Entry point for Trace journal
 *
 * \parm  commanline arguments
 *
 * return \li 0  Normal termination
 */

int main(int argc, char *argv[])
{
	int c = 0;
	int ret = 0;

	while (c != -1)
	{
		int option_index = 0;
		static struct option long_options[] = {
			{"help", 0, 0, 'h'},
			{"current", 0, 0, 'c'},
			{"persistent", 0, 0, 'p'},
			{0, 0, 0, 0}
		};

		if (-1 == (c = getopt_long (argc, argv, "hcp",
						long_options, &option_index)))
		{
			break;
		}

		switch (c)
		{
			case 0:
				if (0 == strcmp(long_options[option_index].name, "current"))
				{
					ret=get_journal_data(CURRENT_MODE);
				}
				else if (0 == strcmp(long_options[option_index].name, "persistent"))
				{
					ret=get_journal_data(BACKUP_MODE);//include current and previous life cycle logs.
				}
				else if (0 == strcmp(long_options[option_index].name, "help"))
				{
					printf("Usage : \n");
					printf("%s\n","       1. trace_journal -current (or)  trace_journal -c\n       2. trace_journal -persistent (or) trace_journal -p\n");


				}
				break;

			case 'h':
				printf("Usage : \n");
				printf("%s\n","       1. trace_journal -current (or)  trace_journal -c\n       2. trace_journal -persistent (or) trace_journal -p\n");

				break;

			case 'c':
				ret=get_journal_data(CURRENT_MODE);
				break;

			case 'p':
				ret=get_journal_data(BACKUP_MODE);
				break;

			default:
				break;
		}
	}

	return ret;
}















